<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class VerifyApiSignature
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next)
    {
        $clientSignature = $request->header('X-SIGNATURE');

        if (! $clientSignature) {
            return response()->json([
                'message' => 'Missing API Signature'
            ], 403);
        }

        $serverSignature = hash_hmac(
            'sha256',
            $request->getContent(),
            config('app.api_signature_secret')
        );

        if (! hash_equals($serverSignature, $clientSignature)) {
            return response()->json([
                'message' => 'Invalid API Signature'
            ], 403);
        }

        return $next($request);
    }
}
