<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Gate;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        /**
         * ======================
         * Create Permissions
         * ======================
         */
        $permissions = [
            'mtn.view',
            'mtn.create',
            'mtn.initiate',
            'mtn.confirm',
            'mtn.refund.initiate',
            'mtn.refund.confirm',
            'mtn.refund.cancel',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        /**
         * ======================
         * Create Roles
         * ======================
         */
        $superAdminRole = Role::firstOrCreate(['name' => 'super admin']);
        $adminRole = Role::firstOrCreate(['name' => 'admin']);
        $mtnRole = Role::firstOrCreate(['name' => 'mtn_role']);

        /**
         * ======================
         * Assign Permissions
         * ======================
         */
        $superAdminRole->syncPermissions(Permission::all());
        
        $adminRole->syncPermissions([
            'mtn.view',
            'mtn.create',
            'mtn.initiate',
            'mtn.confirm',
        ]);
        
        $mtnRole->syncPermissions($permissions);

        /**
         * ======================
         * Create Users - الطريقة المحسنة
         * ======================
         */
        
        // الطريقة 1: استخدام updateOrCreate بدلاً من firstOrCreate
        $superAdmin = User::updateOrCreate(
            ['email' => 'superadmin@tcs.com'],
            [
                'name' => 'Super Admin',
                'password' => bcrypt('ttt123t456t789'), // استخدم bcrypt مباشرة
                'email_verified_at' => now(), // تحقق من البريد الإلكتروني
            ]
        );

        $admin = User::updateOrCreate(
            ['email' => 'admin@tcs.com'],
            [
                'name' => 'Admin',
                'password' => bcrypt('ttt123t456t789'),
                'email_verified_at' => now(),
            ]
        );
        
        $mtn_payment = User::updateOrCreate(
            ['email' => 'mtn_payment@tcs.com'],
            [
                'name' => 'User MTN Payment',
                'password' => bcrypt('tcs@mtn123'),
                'email_verified_at' => now(),
            ]
        );

        /**
         * ======================
         * Assign Roles to Users
         * ======================
         */
        $superAdmin->syncRoles([$superAdminRole]);
        $admin->syncRoles([$adminRole]);
        $mtn_payment->syncRoles([$adminRole]);

        // طباعة معلومات للمساعدة في التصحيح
        $this->command->info('==========================================');
        $this->command->info('Users created/updated:');
        $this->command->info('Super Admin: ' . $superAdmin->email);
        $this->command->info('Admin: ' . $admin->email);
        $this->command->info('Password for both: 123123123');
        $this->command->info('==========================================');

        Gate::before(fn ($user) => $user->hasRole('super admin'));
    }
}