<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\MtnController;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');

// // Public routes (no signature)
// Route::middleware(['throttle:10,1','role:super admin'])->group(function () {
//     Route::post('/register', [AuthController::class, 'register']);
// });
// Route::middleware('throttle:10,1')->group(function () {
//     Route::post('/login', [AuthController::class, 'login']);
// });

// // Authenticated routes
// Route::middleware(['auth:sanctum', 'throttle:60,1'])->group(function () {
//     Route::get('/me', [AuthController::class, 'me']);
//     Route::post('/logout', [AuthController::class, 'logout']);
// });

// Sensitive routes (Signature required)
Route::prefix('/mtn/v1')->middleware(['auth:sanctum', 'api.signature', 'throttle:30,1'])->group(function () {
    Route::post('/activate', [MtnController::class, 'activateTerminal']);

    Route::post('/invoice/create', [MtnController::class, 'createInvoice']);
    Route::post('/invoice/get', [MtnController::class, 'getInvoice']);

    Route::post('/payment/initiate', [MtnController::class, 'initiatePayment']);
    Route::post('/payment/confirm', [MtnController::class, 'confirmPayment']);

    Route::post('/refund/initiate', [MtnController::class, 'refundInitiate']);
    Route::post('/refund/confirm', [MtnController::class, 'refundConfirm']);
    Route::post('/refund/cancel', [MtnController::class, 'refundCancel']);
});


Route::prefix('auth')->group(function () {
    // Protected routes
    Route::middleware(['auth:sanctum','role:super admin'])->group(function () {
        Route::post('/register', [AuthController::class, 'register']);
    });
});
Route::prefix('auth')->group(function () {
    Route::post('login', [AuthController::class, 'login'])->name('login');
    Route::post('refresh', [AuthController::class, 'refresh']);

    // Protected routes
    Route::middleware('auth:sanctum')->group(function () {
        Route::post('logout', [AuthController::class, 'logout']);
        Route::post('logout-all', [AuthController::class, 'logoutAll']);
        Route::get('me', [AuthController::class, 'me']);
    });
});
