<?php
$response = null;
$debug_info = [];

// إعدادات ثابتة
$accessToken = '13|yEtYRNSB4psZ8HIIQROI6jnjcFuY3jhsu9hGKnXpb37b0b61';
$secretKey = 'super-secret-key-123456';
$baseUrl = 'http://192.168.50.8/services/public/api/mtn/v1';

// إعدادات اللغة
session_start();
if (!isset($_SESSION['lang'])) {
    $_SESSION['lang'] = 'ar'; // اللغة الافتراضية: العربية
}

// تغيير اللغة إذا طلب المستخدم
if (isset($_GET['lang']) && in_array($_GET['lang'], ['ar', 'en'])) {
    $_SESSION['lang'] = $_GET['lang'];
}

$lang = $_SESSION['lang'];

// نصوص النظام باللغتين
$translations = [
    'ar' => [
        // العناوين
        'title' => 'نظام فواتير MTN المتكامل',
        'subtitle' => 'إنشاء فواتير، مدفوعات، استرداد، وإدارة كاملة',
        
        // التبويبات
        'get_invoice' => '🔍 استعلام فاتورة',
        'create_invoice' => '➕ إنشاء فاتورة',
        'payment_initiate' => '💳 بدء الدفع',
        'payment_confirm' => '✅ تأكيد الدفع',
        'refund_initiate' => '🔄 بدء استرداد',
        'refund_confirm' => '✓ تأكيد استرداد',
        'refund_cancel' => '❌ إلغاء استرداد',
        
        // عناوين الصفحات
        'get_invoice_title' => 'استعلام عن فاتورة',
        'create_invoice_title' => 'إنشاء فاتورة جديدة',
        'payment_initiate_title' => 'بدء عملية الدفع',
        'payment_confirm_title' => 'تأكيد عملية الدفع',
        'refund_initiate_title' => 'بدء عملية الاسترداد',
        'refund_confirm_title' => 'تأكيد عملية الاسترداد',
        'refund_cancel_title' => 'إلغاء عملية الاسترداد',
        
        // النماذج
        'invoice_number' => 'رقم الفاتورة:',
        'amount' => 'المبلغ (ليرة سورية):',
        'ttl' => 'مدة الصلاحية (دقائق):',
        'phone' => 'رقم هاتف العميل:',
        'guid' => 'معرف GUID:',
        'operation_number' => 'رقم العملية:',
        'confirm_code' => 'كود التأكيد:',
        'base_invoice' => 'رقم الفاتورة الأساسية:',
        'refund_invoice' => 'رقم فاتورة الاسترداد:',
        'cancel_invoice' => 'رقم فاتورة الإلغاء:',
        
        // تلميحات
        'invoice_hint' => 'أدخل رقم الفاتورة الذي تم إنشاؤه مسبقاً',
        'amount_hint' => 'المبلغ بالليرة السورية (مثال: 0.2 = 20 ليرة)',
        'invoice_unique_hint' => 'يجب أن يكون رقم فريد غير مكرر (مثال: 202)',
        'ttl_hint' => 'الافتراضي 30 دقيقة، الحد الأقصى 1440 دقيقة (24 ساعة)',
        'payment_invoice_hint' => 'رقم الفاتورة المراد الدفع لها',
        'phone_hint' => 'رقم الهاتف يجب أن يتكون من 10-15 رقم',
        'guid_hint' => 'معرف فريد يتم تخزينه في الكاش (مثال: TCS-20260115081628-2967)',
        'code_hint' => 'الكود المكون من 6 أرقام المرسل إلى العميل',
        'refund_invoice_hint' => 'رقم الفاتورة التي تم دفعها مسبقاً',
        'base_invoice_hint' => 'رقم الفاتورة الأصلية',
        'refund_confirm_hint' => 'رقم فاتورة الاسترداد الذي تم إنشاؤه',
        'cancel_invoice_hint' => 'رقم فاتورة الاسترداد المراد إلغاؤها',
        
        // أزرار
        'search_invoice' => '🔍 استعلام عن الفاتورة',
        'create_invoice_btn' => '➕ إنشاء الفاتورة',
        'initiate_payment' => '💳 بدء عملية الدفع',
        'confirm_payment' => '✅ تأكيد عملية الدفع',
        'initiate_refund' => '🔄 بدء عملية الاسترداد',
        'confirm_refund' => '✓ تأكيد عملية الاسترداد',
        'cancel_refund' => '❌ إلغاء عملية الاسترداد',
        
        // رسائل الاستجابة
        'success' => '✅ نجاح العملية',
        'error' => '❌ خطأ',
        'http_code' => 'رمز HTTP:',
        'validation_errors' => 'أخطاء التحقق:',
        
        // تفاصيل الفاتورة
        'invoice_details' => 'تفاصيل الفاتورة',
        'invoice_number_label' => 'رقم الفاتورة:',
        'amount_label' => 'المبلغ:',
        'status_label' => 'الحالة:',
        'transaction_label' => 'رقم المعاملة:',
        'paid_label' => 'مدفوعة:',
        'yes' => '✅ نعم',
        'no' => '❌ لا',
        
        // حالات الفاتورة
        'status_pending' => 'معلقة',
        'status_paid' => 'مدفوعة',
        'status_expired' => 'منتهية',
        'status_cancelled' => 'ملغاة',
        'status_unknown' => 'غير معروف',
        
        // QR
        'qr_title' => '📱 كود QR للدفع',
        'qr_instructions' => 'يمكن مسح هذا الكود من تطبيق MTN للدفع',
        
        // معلومات الاتصال
        'connection_info' => '📡 معلومات الاتصال:',
        'api_url' => 'API:',
        'token' => 'Token:',
        'last_update' => '🕐 آخر تحديث:',
        
        // أخطاء
        'invalid_amount' => 'المبلغ يجب أن يكون رقم موجب',
        'invalid_invoice' => 'رقم الفاتورة يجب أن يكون رقم موجب',
        'invalid_ttl' => 'مدة الصلاحية يجب أن تكون بين 1 و 1440 دقيقة',
        'invalid_phone' => 'رقم الهاتف يجب أن يتكون من 10-15 رقم',
        'guid_required' => 'معرف GUID مطلوب',
        'operation_required' => 'رقم العملية مطلوب ويجب أن يكون رقماً',
        'code_required' => 'كود التأكيد يجب أن يتكون من 6 أرقام',
        
        // أخطاء API
        'get_invoice_failed' => 'فشل الحصول على الفاتورة',
        'create_invoice_failed' => 'فشل إنشاء الفاتورة',
        'validation_error' => 'خطأ في التحقق من البيانات',
        'payment_init_failed' => 'فشل بدء عملية الدفع',
        'payment_confirm_failed' => 'فشل تأكيد عملية الدفع',
        'refund_init_failed' => 'فشل بدء عملية الاسترداد',
        'refund_confirm_failed' => 'فشل تأكيد عملية الاسترداد',
        'refund_cancel_failed' => 'فشل إلغاء عملية الاسترداد',
        
        // معلومات المستفيد
        'beneficiary_info' => '📋 معلومات المستفيد',
        
        // تصحيح
        'debug_title' => '🐛 عرض معلومات التصحيح',
        'full_response' => '📄 الاستجابة الكاملة:',
    ],
    
    'en' => [
        // Titles
        'title' => 'MTN Integrated Invoice System',
        'subtitle' => 'Create invoices, payments, refunds, and complete management',
        
        // Tabs
        'get_invoice' => '🔍 Query Invoice',
        'create_invoice' => '➕ Create Invoice',
        'payment_initiate' => '💳 Initiate Payment',
        'payment_confirm' => '✅ Confirm Payment',
        'refund_initiate' => '🔄 Initiate Refund',
        'refund_confirm' => '✓ Confirm Refund',
        'refund_cancel' => '❌ Cancel Refund',
        
        // Page titles
        'get_invoice_title' => 'Query Invoice',
        'create_invoice_title' => 'Create New Invoice',
        'payment_initiate_title' => 'Initiate Payment Process',
        'payment_confirm_title' => 'Confirm Payment Process',
        'refund_initiate_title' => 'Initiate Refund Process',
        'refund_confirm_title' => 'Confirm Refund Process',
        'refund_cancel_title' => 'Cancel Refund Process',
        
        // Forms
        'invoice_number' => 'Invoice Number:',
        'amount' => 'Amount (SYP):',
        'ttl' => 'Validity Period (minutes):',
        'phone' => 'Customer Phone Number:',
        'guid' => 'GUID Identifier:',
        'operation_number' => 'Operation Number:',
        'confirm_code' => 'Confirmation Code:',
        'base_invoice' => 'Base Invoice Number:',
        'refund_invoice' => 'Refund Invoice Number:',
        'cancel_invoice' => 'Cancel Invoice Number:',
        
        // Hints
        'invoice_hint' => 'Enter the invoice number previously created',
        'amount_hint' => 'Amount in Syrian Pounds (example: 0.2 = 20 SYP)',
        'invoice_unique_hint' => 'Must be a unique non-repeating number (example: 202)',
        'ttl_hint' => 'Default 30 minutes, maximum 1440 minutes (24 hours)',
        'payment_invoice_hint' => 'Invoice number to be paid',
        'phone_hint' => 'Phone number must consist of 10-15 digits',
        'guid_hint' => 'Unique identifier stored in cache (example: TCS-20260115081628-2967)',
        'code_hint' => 'The 6-digit code sent to the customer',
        'refund_invoice_hint' => 'Invoice number previously paid',
        'base_invoice_hint' => 'Original invoice number',
        'refund_confirm_hint' => 'Refund invoice number created',
        'cancel_invoice_hint' => 'Refund invoice number to be canceled',
        
        // Buttons
        'search_invoice' => '🔍 Query Invoice',
        'create_invoice_btn' => '➕ Create Invoice',
        'initiate_payment' => '💳 Initiate Payment',
        'confirm_payment' => '✅ Confirm Payment',
        'initiate_refund' => '🔄 Initiate Refund',
        'confirm_refund' => '✓ Confirm Refund',
        'cancel_refund' => '❌ Cancel Refund',
        
        // Response messages
        'success' => '✅ Operation Successful',
        'error' => '❌ Error',
        'http_code' => 'HTTP Code:',
        'validation_errors' => 'Validation Errors:',
        
        // Invoice details
        'invoice_details' => 'Invoice Details',
        'invoice_number_label' => 'Invoice Number:',
        'amount_label' => 'Amount:',
        'status_label' => 'Status:',
        'transaction_label' => 'Transaction Number:',
        'paid_label' => 'Paid:',
        'yes' => '✅ Yes',
        'no' => '❌ No',
        
        // Invoice statuses
        'status_pending' => 'Pending',
        'status_paid' => 'Paid',
        'status_expired' => 'Expired',
        'status_cancelled' => 'Cancelled',
        'status_unknown' => 'Unknown',
        
        // QR
        'qr_title' => '📱 QR Code for Payment',
        'qr_instructions' => 'This code can be scanned from the MTN app for payment',
        
        // Connection info
        'connection_info' => '📡 Connection Information:',
        'api_url' => 'API:',
        'token' => 'Token:',
        'last_update' => '🕐 Last Update:',
        
        // Errors
        'invalid_amount' => 'Amount must be a positive number',
        'invalid_invoice' => 'Invoice number must be a positive number',
        'invalid_ttl' => 'Validity period must be between 1 and 1440 minutes',
        'invalid_phone' => 'Phone number must consist of 10-15 digits',
        'guid_required' => 'GUID identifier required',
        'operation_required' => 'Operation number required and must be numeric',
        'code_required' => 'Confirmation code must consist of 6 digits',
        
        // API errors
        'get_invoice_failed' => 'Failed to get invoice',
        'create_invoice_failed' => 'Failed to create invoice',
        'validation_error' => 'Data validation error',
        'payment_init_failed' => 'Failed to initiate payment',
        'payment_confirm_failed' => 'Failed to confirm payment',
        'refund_init_failed' => 'Failed to initiate refund',
        'refund_confirm_failed' => 'Failed to confirm refund',
        'refund_cancel_failed' => 'Failed to cancel refund',
        
        // Beneficiary info
        'beneficiary_info' => '📋 Beneficiary Information',
        
        // Debug
        'debug_title' => '🐛 Show Debug Information',
        'full_response' => '📄 Full Response:',
    ]
];

// دالة ترجمة بسيطة
function t($key) {
    global $lang, $translations;
    return $translations[$lang][$key] ?? $key;
}

/**
 * دالة إرسال الطلبات العامة
 */
function sendMTNRequest($endpoint, $payload, $accessToken, $secretKey) {
    global $baseUrl;
    $url = $baseUrl . $endpoint;
    
    // إنشاء التوقيع بالطريقة الصحيحة (JSON)
    $signature = hash_hmac('sha256', json_encode($payload), $secretKey);
    
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => json_encode($payload),
        CURLOPT_HTTPHEADER => [
            'Authorization: Bearer ' . $accessToken,
            'X-SIGNATURE: ' . $signature,
            'Accept: application/json',
            'Content-Type: application/json'
        ],
    ]);
    
    $result = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    return [
        'code' => $httpCode,
        'response' => $result,
        'response_json' => json_decode($result, true),
        'signature' => $signature
    ];
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    
    if ($action === 'get_invoice') {
        // ============ Get Invoice ============
        $invoice = (int)($_POST['invoice'] ?? 0);
        
        if ($invoice <= 0) {
            $response = ['error' => t('invalid_invoice')];
        } else {
            $payload = ['invoice' => $invoice];
            $result = sendMTNRequest('/invoice/get', $payload, $accessToken, $secretKey);
            
            $debug_info = [
                'endpoint' => '/invoice/get',
                'payload' => $payload,
                'signature' => $result['signature'],
                'http_code' => $result['code']
            ];
            
            if ($result['code'] == 200) {
                $response = $result['response_json'];
            } else {
                $response = [
                    'error' => t('get_invoice_failed'),
                    'http_code' => $result['code'],
                    'response' => $result['response_json']
                ];
            }
        }
        
    } elseif ($action === 'create_invoice') {
        // ============ Create Invoice ============
        $amount = $_POST['amount'] ?? '';
        $invoice = (int)($_POST['invoice'] ?? 0);
        $ttl = (int)($_POST['ttl'] ?? 30);
        
        // التحقق من البيانات
        $errors = [];
        if (empty($amount) || !is_numeric($amount) || $amount <= 0) {
            $errors[] = t('invalid_amount');
        }
        if ($invoice <= 0) {
            $errors[] = t('invalid_invoice');
        }
        if ($ttl <= 0 || $ttl > 1440) {
            $errors[] = t('invalid_ttl');
        }
        
        if (!empty($errors)) {
            $response = ['error' => implode('، ', $errors)];
        } else {
            $payload = [
                'amount' => (float)$amount,
                'invoice' => $invoice,
                'ttl' => $ttl
            ];
            
            $result = sendMTNRequest('/invoice/create', $payload, $accessToken, $secretKey);
            
            $debug_info = [
                'endpoint' => '/invoice/create',
                'payload' => $payload,
                'signature' => $result['signature'],
                'http_code' => $result['code']
            ];
            
            if ($result['code'] == 200) {
                $response = $result['response_json'];
            } elseif ($result['code'] == 422) {
                $response = [
                    'error' => t('validation_error'),
                    'validation_errors' => $result['response_json']['errors'] ?? [],
                    'response' => $result['response_json']
                ];
            } else {
                $response = [
                    'error' => t('create_invoice_failed'),
                    'http_code' => $result['code'],
                    'response' => $result['response_json']
                ];
            }
        }
        
    } elseif ($action === 'payment_initiate') {
        // ============ Payment Initiate ============
        $invoice = (int)($_POST['payment_invoice'] ?? 0);
        $phone_client = $_POST['phone_client'] ?? '';
        $guid = $_POST['guid'] ?? '';
        
        // التحقق من البيانات
        $errors = [];
        if ($invoice <= 0) {
            $errors[] = t('invalid_invoice');
        }
        if (empty($phone_client) || !preg_match('/^[0-9]{10,15}$/', $phone_client)) {
            $errors[] = t('invalid_phone');
        }
        if (empty($guid)) {
            $errors[] = t('guid_required');
        }
        
        if (!empty($errors)) {
            $response = ['error' => implode('، ', $errors)];
        } else {
            $payload = [
                'invoice' => $invoice,
                'phone_clinte' => $phone_client,
                'guid' => $guid
            ];
            
            $result = sendMTNRequest('/payment/initiate', $payload, $accessToken, $secretKey);
            
            $debug_info = [
                'endpoint' => '/payment/initiate',
                'payload' => $payload,
                'signature' => $result['signature'],
                'http_code' => $result['code']
            ];
            
            if ($result['code'] == 200) {
                $response = $result['response_json'];
            } elseif ($result['code'] == 422) {
                $response = [
                    'error' => t('validation_error'),
                    'validation_errors' => $result['response_json']['errors'] ?? [],
                    'response' => $result['response_json']
                ];
            } else {
                $response = [
                    'error' => t('payment_init_failed'),
                    'http_code' => $result['code'],
                    'response' => $result['response_json']
                ];
            }
        }
        
    } elseif ($action === 'payment_confirm') {
        // ============ Payment Confirm ============
        $phone = $_POST['confirm_phone'] ?? '';
        $guid = $_POST['confirm_guid'] ?? '';
        $operation_number = $_POST['operation_number'] ?? '';
        $invoice = (int)($_POST['confirm_invoice'] ?? 0);
        $code = $_POST['confirm_code'] ?? '';
        
        // التحقق من البيانات
        $errors = [];
        if (empty($phone) || !preg_match('/^[0-9]{10,15}$/', $phone)) {
            $errors[] = t('invalid_phone');
        }
        if (empty($guid)) {
            $errors[] = t('guid_required');
        }
        if (empty($operation_number) || !is_numeric($operation_number)) {
            $errors[] = t('operation_required');
        }
        if ($invoice <= 0) {
            $errors[] = t('invalid_invoice');
        }
        if (empty($code) || !preg_match('/^[0-9]{6}$/', $code)) {
            $errors[] = t('code_required');
        }
        
        if (!empty($errors)) {
            $response = ['error' => implode('، ', $errors)];
        } else {
            $payload = [
                'phone' => $phone,
                'guid' => $guid,
                'operation_number' => $operation_number,
                'invoice' => $invoice,
                'code' => $code
            ];
            
            $result = sendMTNRequest('/payment/confirm', $payload, $accessToken, $secretKey);
            
            $debug_info = [
                'endpoint' => '/payment/confirm',
                'payload' => $payload,
                'signature' => $result['signature'],
                'http_code' => $result['code']
            ];
            
            if ($result['code'] == 200) {
                $response = $result['response_json'];
            } elseif ($result['code'] == 422) {
                $response = [
                    'error' => t('validation_error'),
                    'validation_errors' => $result['response_json']['errors'] ?? [],
                    'response' => $result['response_json']
                ];
            } else {
                $response = [
                    'error' => t('payment_confirm_failed'),
                    'http_code' => $result['code'],
                    'response' => $result['response_json']
                ];
            }
        }
        
    } elseif ($action === 'refund_initiate') {
        // ============ Refund Initiate ============
        $invoice = (int)($_POST['refund_invoice'] ?? 0);
        
        if ($invoice <= 0) {
            $response = ['error' => t('invalid_invoice')];
        } else {
            $payload = ['invoice' => $invoice];
            $result = sendMTNRequest('/refund/initiate', $payload, $accessToken, $secretKey);
            
            $debug_info = [
                'endpoint' => '/refund/initiate',
                'payload' => $payload,
                'signature' => $result['signature'],
                'http_code' => $result['code']
            ];
            
            if ($result['code'] == 200) {
                $response = $result['response_json'];
            } else {
                $response = [
                    'error' => t('refund_init_failed'),
                    'http_code' => $result['code'],
                    'response' => $result['response_json']
                ];
            }
        }
        
    } elseif ($action === 'refund_confirm') {
        // ============ Refund Confirm ============
        $base_invoice = (int)($_POST['base_invoice'] ?? 0);
        $refund_invoice = (int)($_POST['refund_invoice_confirm'] ?? 0);
        
        // التحقق من البيانات
        $errors = [];
        if ($base_invoice <= 0) {
            $errors[] = t('invalid_invoice');
        }
        if ($refund_invoice <= 0) {
            $errors[] = t('invalid_invoice');
        }
        
        if (!empty($errors)) {
            $response = ['error' => implode('، ', $errors)];
        } else {
            $payload = [
                'base_invoice' => $base_invoice,
                'refund_invoice' => $refund_invoice
            ];
            
            $result = sendMTNRequest('/refund/confirm', $payload, $accessToken, $secretKey);
            
            $debug_info = [
                'endpoint' => '/refund/confirm',
                'payload' => $payload,
                'signature' => $result['signature'],
                'http_code' => $result['code']
            ];
            
            if ($result['code'] == 200) {
                $response = $result['response_json'];
            } elseif ($result['code'] == 422) {
                $response = [
                    'error' => t('validation_error'),
                    'validation_errors' => $result['response_json']['errors'] ?? [],
                    'response' => $result['response_json']
                ];
            } else {
                $response = [
                    'error' => t('refund_confirm_failed'),
                    'http_code' => $result['code'],
                    'response' => $result['response_json']
                ];
            }
        }
        
    } elseif ($action === 'refund_cancel') {
        // ============ Refund Cancel ============
        $invoice_cancel_id = (int)($_POST['invoice_cancel_id'] ?? 0);
        
        if ($invoice_cancel_id <= 0) {
            $response = ['error' => t('invalid_invoice')];
        } else {
            $payload = ['invoice_cancel_id' => $invoice_cancel_id];
            $result = sendMTNRequest('/refund/cancel', $payload, $accessToken, $secretKey);
            
            $debug_info = [
                'endpoint' => '/refund/cancel',
                'payload' => $payload,
                'signature' => $result['signature'],
                'http_code' => $result['code']
            ];
            
            if ($result['code'] == 200) {
                $response = $result['response_json'];
            } else {
                $response = [
                    'error' => t('refund_cancel_failed'),
                    'http_code' => $result['code'],
                    'response' => $result['response_json']
                ];
            }
        }
    }
}

// تحديد اتجاه الصفحة بناءً على اللغة
$direction = $lang === 'ar' ? 'rtl' : 'ltr';
$text_align = $lang === 'ar' ? 'right' : 'left';
?>

<!DOCTYPE html>
<html lang="<?php echo $lang; ?>" dir="<?php echo $direction; ?>">
<head>
    <meta charset="UTF-8">
    <title><?php echo t('title'); ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        
        .container {
            max-width: 1400px;
            margin: 0 auto;
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            overflow: hidden;
        }
        
        header {
            background: linear-gradient(to right, #4f46e5, #7c3aed);
            color: white;
            padding: 30px;
            text-align: center;
            position: relative;
        }
        
        .language-switcher {
            position: absolute;
            top: 20px;
            <?php echo $lang === 'ar' ? 'left: 20px;' : 'right: 20px;'; ?>
            background: rgba(255, 255, 255, 0.2);
            border-radius: 20px;
            padding: 5px;
            display: flex;
        }
        
        .language-switcher a {
            color: white;
            text-decoration: none;
            padding: 8px 16px;
            border-radius: 15px;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .language-switcher a.active {
            background: white;
            color: #4f46e5;
        }
        
        .language-switcher a:hover {
            background: rgba(255, 255, 255, 0.3);
        }
        
        header h1 {
            font-size: 32px;
            margin-bottom: 10px;
        }
        
        header p {
            opacity: 0.9;
            font-size: 16px;
        }
        
        .tabs {
            display: flex;
            background: #f8fafc;
            border-bottom: 2px solid #e2e8f0;
            flex-wrap: wrap;
        }
        
        .tab {
            flex: 1;
            padding: 20px;
            text-align: center;
            background: none;
            border: none;
            font-size: 18px;
            font-weight: 600;
            color: #64748b;
            cursor: pointer;
            transition: all 0.3s;
            border-bottom: 3px solid transparent;
            min-width: 200px;
        }
        
        .tab:hover {
            background: #f1f5f9;
            color: #475569;
        }
        
        .tab.active {
            color: #4f46e5;
            border-bottom-color: #4f46e5;
            background: white;
        }
        
        .tab-content {
            display: none;
            padding: 40px;
        }
        
        .tab-content.active {
            display: block;
        }
        
        .form-container {
            max-width: 800px;
            margin: 0 auto;
        }
        
        .form-group {
            margin-bottom: 25px;
            text-align: <?php echo $text_align; ?>;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 10px;
            color: #334155;
            font-weight: 600;
            font-size: 16px;
        }
        
        .form-group input {
            width: 100%;
            padding: 15px;
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            font-size: 16px;
            transition: all 0.3s;
            background: #f8fafc;
            text-align: <?php echo $text_align; ?>;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: #4f46e5;
            background: white;
            box-shadow: 0 0 0 3px rgba(79, 70, 229, 0.1);
        }
        
        .form-group .hint {
            margin-top: 8px;
            color: #64748b;
            font-size: 14px;
            text-align: <?php echo $text_align; ?>;
        }
        
        .btn {
            display: block;
            width: 100%;
            padding: 18px;
            background: linear-gradient(to right, #4f46e5, #7c3aed);
            color: white;
            border: none;
            border-radius: 12px;
            font-size: 18px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            margin-top: 10px;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(79, 70, 229, 0.3);
        }
        
        .btn:active {
            transform: translateY(0);
        }
        
        .response-container {
            margin-top: 40px;
            background: #f8fafc;
            border-radius: 15px;
            padding: 25px;
            border: 2px solid #e2e8f0;
        }
        
        .response-title {
            color: #334155;
            margin-bottom: 20px;
            font-size: 20px;
            display: flex;
            align-items: center;
            gap: 10px;
            text-align: <?php echo $text_align; ?>;
        }
        
        .response-title.success {
            color: #059669;
        }
        
        .response-title.error {
            color: #dc2626;
        }
        
        pre {
            background: #1e293b;
            color: #e2e8f0;
            padding: 20px;
            border-radius: 10px;
            overflow-x: auto;
            font-size: 14px;
            line-height: 1.5;
            max-height: 500px;
            overflow-y: auto;
            text-align: left;
            direction: ltr;
        }
        
        .qr-container {
            text-align: center;
            margin: 20px 0;
            padding: 25px;
            background: white;
            border-radius: 10px;
            border: 2px dashed #cbd5e1;
        }
        
        .qr-code {
            font-family: monospace;
            background: #f1f5f9;
            padding: 15px;
            border-radius: 8px;
            margin: 15px 0;
            word-break: break-all;
            font-size: 12px;
            line-height: 1.4;
            direction: ltr;
            text-align: left;
        }
        
        .invoice-details {
            background: white;
            border-radius: 10px;
            padding: 20px;
            margin-top: 20px;
            border: 1px solid #e2e8f0;
        }
        
        .detail-row {
            display: flex;
            margin-bottom: 12px;
            padding-bottom: 12px;
            border-bottom: 1px solid #f1f5f9;
            text-align: <?php echo $text_align; ?>;
        }
        
        .detail-label {
            width: 200px;
            font-weight: 600;
            color: #475569;
        }
        
        .detail-value {
            flex: 1;
            color: #1e293b;
        }
        
        .status-badge {
            display: inline-block;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: 600;
        }
        
        .status-pending {
            background: #fef3c7;
            color: #92400e;
        }
        
        .status-paid {
            background: #d1fae5;
            color: #065f46;
        }
        
        .status-expired {
            background: #fee2e2;
            color: #991b1b;
        }
        
        .debug-info {
            margin-top: 30px;
            background: #fffbeb;
            border: 1px solid #fde68a;
            border-radius: 10px;
            padding: 20px;
        }
        
        .debug-toggle {
            background: #f59e0b;
            color: white;
            border: none;
            padding: 10px 20px;
            border-radius: 8px;
            cursor: pointer;
            font-weight: 600;
            margin-bottom: 15px;
            text-align: <?php echo $text_align; ?>;
        }
        
        .debug-content {
            display: none;
        }
        
        .debug-content.show {
            display: block;
        }
        
        .two-column {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
        }
        
        @media (max-width: 768px) {
            .container {
                border-radius: 10px;
            }
            
            header {
                padding: 20px;
            }
            
            header h1 {
                font-size: 24px;
            }
            
            .language-switcher {
                position: relative;
                top: 0;
                left: 0;
                right: 0;
                justify-content: center;
                margin-bottom: 15px;
            }
            
            .tab-content {
                padding: 20px;
            }
            
            .detail-row {
                flex-direction: column;
            }
            
            .detail-label {
                width: 100%;
                margin-bottom: 5px;
            }
            
            .two-column {
                grid-template-columns: 1fr;
            }
            
            .tab {
                min-width: 150px;
                padding: 15px;
                font-size: 16px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <header>
            <div class="language-switcher">
                <a href="?lang=ar" class="<?php echo $lang === 'ar' ? 'active' : ''; ?>">العربية</a>
                <a href="?lang=en" class="<?php echo $lang === 'en' ? 'active' : ''; ?>">English</a>
            </div>
            
            <h1><?php echo t('title'); ?></h1>
            <p><?php echo t('subtitle'); ?></p>
        </header>
        
        <div class="tabs">
            <button class="tab active" onclick="switchTab('get')"><?php echo t('get_invoice'); ?></button>
            <button class="tab" onclick="switchTab('create')"><?php echo t('create_invoice'); ?></button>
            <button class="tab" onclick="switchTab('payment_init')"><?php echo t('payment_initiate'); ?></button>
            <button class="tab" onclick="switchTab('payment_confirm')"><?php echo t('payment_confirm'); ?></button>
            <button class="tab" onclick="switchTab('refund_init')"><?php echo t('refund_initiate'); ?></button>
            <button class="tab" onclick="switchTab('refund_confirm')"><?php echo t('refund_confirm'); ?></button>
            <button class="tab" onclick="switchTab('refund_cancel')"><?php echo t('refund_cancel'); ?></button>
        </div>
        
        <!-- تبويب استعلام الفاتورة / Invoice Query Tab -->
        <div id="get" class="tab-content active">
            <div class="form-container">
                <h2 style="color: #4f46e5; margin-bottom: 30px; text-align: center;"><?php echo t('get_invoice_title'); ?></h2>
                
                <form method="post">
                    <input type="hidden" name="action" value="get_invoice">
                    
                    <div class="form-group">
                        <label for="get_invoice"><?php echo t('invoice_number'); ?></label>
                        <input type="number" 
                               id="get_invoice" 
                               name="invoice" 
                               placeholder="12345" 
                               required
                               min="1">
                        <div class="hint"><?php echo t('invoice_hint'); ?></div>
                    </div>
                    
                    <button type="submit" class="btn"><?php echo t('search_invoice'); ?></button>
                </form>
            </div>
        </div>
        
        <!-- تبويب إنشاء الفاتورة / Create Invoice Tab -->
        <div id="create" class="tab-content">
            <div class="form-container">
                <h2 style="color: #7c3aed; margin-bottom: 30px; text-align: center;"><?php echo t('create_invoice_title'); ?></h2>
                
                <form method="post">
                    <input type="hidden" name="action" value="create_invoice">
                    
                    <div class="form-group">
                        <label for="amount"><?php echo t('amount'); ?></label>
                        <input type="number" 
                               step="0.01" 
                               id="amount" 
                               name="amount" 
                               placeholder="0.2" 
                               required
                               min="0.01">
                        <div class="hint"><?php echo t('amount_hint'); ?></div>
                    </div>
                    
                    <div class="form-group">
                        <label for="create_invoice"><?php echo t('invoice_number'); ?></label>
                        <input type="number" 
                               id="create_invoice" 
                               name="invoice" 
                               placeholder="202" 
                               required
                               min="1">
                        <div class="hint"><?php echo t('invoice_unique_hint'); ?></div>
                    </div>
                    
                    <div class="form-group">
                        <label for="ttl"><?php echo t('ttl'); ?></label>
                        <input type="number" 
                               id="ttl" 
                               name="ttl" 
                               placeholder="30" 
                               value="30"
                               min="1"
                               max="1440">
                        <div class="hint"><?php echo t('ttl_hint'); ?></div>
                    </div>
                    
                    <button type="submit" class="btn"><?php echo t('create_invoice_btn'); ?></button>
                </form>
            </div>
        </div>
        
        <!-- تبويب بدء الدفع / Initiate Payment Tab -->
        <div id="payment_init" class="tab-content">
            <div class="form-container">
                <h2 style="color: #10b981; margin-bottom: 30px; text-align: center;"><?php echo t('payment_initiate_title'); ?></h2>
                
                <form method="post">
                    <input type="hidden" name="action" value="payment_initiate">
                    
                    <div class="form-group">
                        <label for="payment_invoice"><?php echo t('invoice_number'); ?></label>
                        <input type="number" 
                               id="payment_invoice" 
                               name="payment_invoice" 
                               placeholder="202" 
                               required
                               min="1">
                        <div class="hint"><?php echo t('payment_invoice_hint'); ?></div>
                    </div>
                    
                    <div class="form-group">
                        <label for="phone_client"><?php echo t('phone'); ?></label>
                        <input type="text" 
                               id="phone_client" 
                               name="phone_client" 
                               placeholder="963950514975" 
                               required
                               pattern="[0-9]{10,15}">
                        <div class="hint"><?php echo t('phone_hint'); ?></div>
                    </div>
                    
                    <div class="form-group">
                        <label for="guid"><?php echo t('guid'); ?></label>
                        <input type="text" 
                               id="guid" 
                               name="guid" 
                               placeholder="TCS-20260115081628-2967" 
                               required>
                        <div class="hint"><?php echo t('guid_hint'); ?></div>
                    </div>
                    
                    <button type="submit" class="btn"><?php echo t('initiate_payment'); ?></button>
                </form>
            </div>
        </div>
        
        <!-- تبويب تأكيد الدفع / Confirm Payment Tab -->
        <div id="payment_confirm" class="tab-content">
            <div class="form-container">
                <h2 style="color: #059669; margin-bottom: 30px; text-align: center;"><?php echo t('payment_confirm_title'); ?></h2>
                
                <form method="post">
                    <input type="hidden" name="action" value="payment_confirm">
                    
                    <div class="two-column">
                        <div class="form-group">
                            <label for="confirm_phone"><?php echo t('phone'); ?></label>
                            <input type="text" 
                                   id="confirm_phone" 
                                   name="confirm_phone" 
                                   placeholder="963950514975" 
                                   required
                                   pattern="[0-9]{10,15}">
                        </div>
                        
                        <div class="form-group">
                            <label for="confirm_guid"><?php echo t('guid'); ?></label>
                            <input type="text" 
                                   id="confirm_guid" 
                                   name="confirm_guid" 
                                   placeholder="TCS-20260115081628-2967" 
                                   required>
                        </div>
                    </div>
                    
                    <div class="two-column">
                        <div class="form-group">
                            <label for="operation_number"><?php echo t('operation_number'); ?></label>
                            <input type="text" 
                                   id="operation_number" 
                                   name="operation_number" 
                                   placeholder="7007531401826869" 
                                   required
                                   pattern="[0-9]+">
                        </div>
                        
                        <div class="form-group">
                            <label for="confirm_invoice"><?php echo t('invoice_number'); ?></label>
                            <input type="number" 
                                   id="confirm_invoice" 
                                   name="confirm_invoice" 
                                   placeholder="202" 
                                   required
                                   min="1">
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="confirm_code"><?php echo t('confirm_code'); ?></label>
                        <input type="text" 
                               id="confirm_code" 
                               name="confirm_code" 
                               placeholder="123456" 
                               required
                               pattern="[0-9]{6}"
                               maxlength="6">
                        <div class="hint"><?php echo t('code_hint'); ?></div>
                    </div>
                    
                    <button type="submit" class="btn"><?php echo t('confirm_payment'); ?></button>
                </form>
            </div>
        </div>
        
        <!-- تبويب بدء الاسترداد / Initiate Refund Tab -->
        <div id="refund_init" class="tab-content">
            <div class="form-container">
                <h2 style="color: #f59e0b; margin-bottom: 30px; text-align: center;"><?php echo t('refund_initiate_title'); ?></h2>
                
                <form method="post">
                    <input type="hidden" name="action" value="refund_initiate">
                    
                    <div class="form-group">
                        <label for="refund_invoice"><?php echo t('refund_invoice'); ?></label>
                        <input type="number" 
                               id="refund_invoice" 
                               name="refund_invoice" 
                               placeholder="202" 
                               required
                               min="1">
                        <div class="hint"><?php echo t('refund_invoice_hint'); ?></div>
                    </div>
                    
                    <button type="submit" class="btn"><?php echo t('initiate_refund'); ?></button>
                </form>
            </div>
        </div>
        
        <!-- تبويب تأكيد الاسترداد / Confirm Refund Tab -->
        <div id="refund_confirm" class="tab-content">
            <div class="form-container">
                <h2 style="color: #3b82f6; margin-bottom: 30px; text-align: center;"><?php echo t('refund_confirm_title'); ?></h2>
                
                <form method="post">
                    <input type="hidden" name="action" value="refund_confirm">
                    
                    <div class="two-column">
                        <div class="form-group">
                            <label for="base_invoice"><?php echo t('base_invoice'); ?></label>
                            <input type="number" 
                                   id="base_invoice" 
                                   name="base_invoice" 
                                   placeholder="200" 
                                   required
                                   min="1">
                            <div class="hint"><?php echo t('base_invoice_hint'); ?></div>
                        </div>
                        
                        <div class="form-group">
                            <label for="refund_invoice_confirm"><?php echo t('refund_invoice'); ?></label>
                            <input type="number" 
                                   id="refund_invoice_confirm" 
                                   name="refund_invoice_confirm" 
                                   placeholder="201" 
                                   required
                                   min="1">
                            <div class="hint"><?php echo t('refund_confirm_hint'); ?></div>
                        </div>
                    </div>
                    
                    <button type="submit" class="btn"><?php echo t('confirm_refund'); ?></button>
                </form>
            </div>
        </div>
        
        <!-- تبويب إلغاء الاسترداد / Cancel Refund Tab -->
        <div id="refund_cancel" class="tab-content">
            <div class="form-container">
                <h2 style="color: #dc2626; margin-bottom: 30px; text-align: center;"><?php echo t('refund_cancel_title'); ?></h2>
                
                <form method="post">
                    <input type="hidden" name="action" value="refund_cancel">
                    
                    <div class="form-group">
                        <label for="invoice_cancel_id"><?php echo t('cancel_invoice'); ?></label>
                        <input type="number" 
                               id="invoice_cancel_id" 
                               name="invoice_cancel_id" 
                               placeholder="201" 
                               required
                               min="1">
                        <div class="hint"><?php echo t('cancel_invoice_hint'); ?></div>
                    </div>
                    
                    <button type="submit" class="btn"><?php echo t('cancel_refund'); ?></button>
                </form>
            </div>
        </div>
        
        <!-- عرض النتائج / Display Results -->
        <?php if ($response): ?>
            <div class="response-container">
                <?php if (isset($response['error'])): ?>
                    <div class="response-title error">
                        <?php echo t('error'); ?> <?php echo $response['error']; ?>
                    </div>
                    
                    <?php if (isset($response['http_code'])): ?>
                        <div style="background: #fee2e2; padding: 15px; border-radius: 8px; margin: 15px 0; text-align: <?php echo $text_align; ?>;">
                            <strong><?php echo t('http_code'); ?></strong> <?php echo $response['http_code']; ?>
                        </div>
                    <?php endif; ?>
                    
                    <?php if (isset($response['validation_errors'])): ?>
                        <div style="background: #fef3c7; padding: 15px; border-radius: 8px; margin: 15px 0; text-align: <?php echo $text_align; ?>;">
                            <strong><?php echo t('validation_errors'); ?></strong>
                            <pre style="background: transparent; color: #92400e;"><?php 
                                print_r($response['validation_errors']); 
                            ?></pre>
                        </div>
                    <?php endif; ?>
                    
                <?php else: ?>
                    <div class="response-title success">
                        <?php echo t('success'); ?>
                    </div>
                    
                    <?php if (isset($response[0]['Receipt'])): ?>
                        <?php $receipt = $response[0]['Receipt']; ?>
                        
                        <div class="invoice-details">
                            <h3 style="color: #475569; margin-bottom: 15px;"><?php echo t('invoice_details'); ?></h3>
                            
                            <div class="detail-row">
                                <div class="detail-label"><?php echo t('invoice_number_label'); ?></div>
                                <div class="detail-value"><?php echo $receipt['Invoice'] ?? 'N/A'; ?></div>
                            </div>
                            
                            <?php if (isset($receipt['Amount'])): ?>
                                <div class="detail-row">
                                    <div class="detail-label"><?php echo t('amount_label'); ?></div>
                                    <div class="detail-value"><?php echo ($receipt['Amount'] / 100) . ' SYP'; ?></div>
                                </div>
                            <?php endif; ?>
                            
                            <?php if (isset($receipt['Status'])): ?>
                                <div class="detail-row">
                                    <div class="detail-label"><?php echo t('status_label'); ?></div>
                                    <div class="detail-value">
                                        <?php 
                                        $status = $receipt['Status'] ?? 0;
                                        $statusText = match($status) {
                                            1 => '<span class="status-badge status-pending">' . t('status_pending') . '</span>',
                                            2 => '<span class="status-badge status-paid">' . t('status_paid') . '</span>',
                                            3 => '<span class="status-badge status-expired">' . t('status_expired') . '</span>',
                                            4 => '<span class="status-badge">' . t('status_cancelled') . '</span>',
                                            default => '<span class="status-badge">' . t('status_unknown') . '</span>'
                                        };
                                        echo $statusText . ' (Code: ' . $status . ')';
                                        ?>
                                    </div>
                                </div>
                            <?php endif; ?>
                            
                            <?php if (isset($receipt['Transaction'])): ?>
                                <div class="detail-row">
                                    <div class="detail-label"><?php echo t('transaction_label'); ?></div>
                                    <div class="detail-value"><?php echo $receipt['Transaction']; ?></div>
                                </div>
                            <?php endif; ?>
                            
                            <?php if (isset($receipt['Paid'])): ?>
                                <div class="detail-row">
                                    <div class="detail-label"><?php echo t('paid_label'); ?></div>
                                    <div class="detail-value"><?php echo $receipt['Paid'] ? t('yes') : t('no'); ?></div>
                                </div>
                            <?php endif; ?>
                            
                            <?php if (!empty($receipt['Qr'])): ?>
                                <div class="qr-container">
                                    <h3 style="color: #4f46e5; margin-bottom: 15px;"><?php echo t('qr_title'); ?></h3>
                                    <div class="qr-code"><?php echo htmlspecialchars($receipt['Qr']); ?></div>
                                    <p style="color: #64748b; font-size: 14px;">
                                        <?php echo t('qr_instructions'); ?>
                                    </p>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                    <?php elseif (isset($response[0]['Errno'])): ?>
                        <div style="background: #d1fae5; padding: 15px; border-radius: 8px; margin: 15px 0; text-align: <?php echo $text_align; ?>;">
                            <strong>Error Number:</strong> <?php echo $response[0]['Errno']; ?>
                        </div>
                        
                        <?php if (isset($response[0]['OperationNumber'])): ?>
                            <div style="background: #dbeafe; padding: 15px; border-radius: 8px; margin: 15px 0; text-align: <?php echo $text_align; ?>;">
                                <strong>Operation Number:</strong> <?php echo $response[0]['OperationNumber']; ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (isset($response[0]['Transaction'])): ?>
                            <div style="background: #d1fae5; padding: 15px; border-radius: 8px; margin: 15px 0; text-align: <?php echo $text_align; ?>;">
                                <strong>Transaction Number:</strong> <?php echo $response[0]['Transaction']; ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (isset($response[0]['Parameters'])): ?>
                            <div class="invoice-details">
                                <h3 style="color: #475569; margin-bottom: 15px;"><?php echo t('beneficiary_info'); ?></h3>
                                <?php foreach ($response[0]['Parameters'] as $param): ?>
                                    <div class="detail-row">
                                        <div class="detail-label"><?php echo $param['Name'] ?? $param['ParameterName']; ?>:</div>
                                        <div class="detail-value"><?php echo $param['Data']; ?></div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (isset($response[0]['RefundInvoice'])): ?>
                            <div style="background: #f0f9ff; padding: 15px; border-radius: 8px; margin: 15px 0; text-align: <?php echo $text_align; ?>;">
                                <strong>Refund Invoice:</strong> <?php echo $response[0]['RefundInvoice']; ?>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                    
                    <h3 style="color: #475569; margin: 25px 0 15px; text-align: <?php echo $text_align; ?>;"><?php echo t('full_response'); ?></h3>
                    <pre><?php print_r($response); ?></pre>
                <?php endif; ?>
                
                <!-- معلومات التصحيح / Debug Information -->
                <?php if (!empty($debug_info)): ?>
                    <div class="debug-info">
                        <button class="debug-toggle" onclick="toggleDebug()"><?php echo t('debug_title'); ?></button>
                        <div class="debug-content" id="debugContent">
                            <pre><?php print_r($debug_info); ?></pre>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        
        <!-- معلومات الاتصال / Connection Information -->
        <div style="padding: 20px; background: #f8fafc; border-top: 2px solid #e2e8f0; text-align: center; color: #64748b; font-size: 14px;">
            <p><strong><?php echo t('connection_info'); ?></strong> 
                <?php echo t('api_url'); ?> <?php echo $baseUrl; ?> | 
                <?php echo t('token'); ?> <?php echo substr($accessToken, 0, 10) . '...'; ?>
            </p>
            <p><?php echo t('last_update'); ?> <?php echo date('Y-m-d H:i:s'); ?></p>
        </div>
    </div>
    
    <script>
        // تبديل التبويبات / Switch Tabs
        function switchTab(tabName) {
            // إخفاء جميع المحتويات / Hide all contents
            document.querySelectorAll('.tab-content').forEach(content => {
                content.classList.remove('active');
            });
            
            // إزالة النشط من جميع الأزرار / Remove active from all buttons
            document.querySelectorAll('.tab').forEach(tab => {
                tab.classList.remove('active');
            });
            
            // إظهار المحتوى المطلوب / Show requested content
            document.getElementById(tabName).classList.add('active');
            
            // جعل الزر نشط / Make button active
            event.target.classList.add('active');
            
            // توليد بيانات عشوائية للاختبار / Generate random test data
            populateTestData(tabName);
        }
        
        // تبديل عرض معلومات التصحيح / Toggle debug information display
        function toggleDebug() {
            const debugContent = document.getElementById('debugContent');
            debugContent.classList.toggle('show');
        }
        
        // تعبئة تلقائية للحقول / Auto-fill fields
        document.addEventListener('DOMContentLoaded', function() {
            // تعبئة حقول المثال / Fill example fields
            const urlParams = new URLSearchParams(window.location.search);
            const invoice = urlParams.get('invoice');
            
            if (invoice) {
                document.getElementById('get_invoice').value = invoice;
            }
            
            // توليد بيانات عشوائية للاختبار / Generate random test data
            populateTestData('create');
        });
        
        // التحقق من صحة البيانات قبل الإرسال / Validate data before submission
        document.querySelectorAll('form').forEach(form => {
            form.addEventListener('submit', function(e) {
                const action = this.querySelector('input[name="action"]').value;
                let isValid = true;
                
                if (action === 'create_invoice') {
                    const amount = parseFloat(this.querySelector('input[name="amount"]').value);
                    const invoice = parseInt(this.querySelector('input[name="invoice"]').value);
                    const ttl = parseInt(this.querySelector('input[name="ttl"]').value);
                    
                    if (amount <= 0) {
                        alert('<?php echo $lang === "ar" ? "يرجى إدخال مبلغ صحيح أكبر من صفر" : "Please enter a valid amount greater than zero"; ?>');
                        isValid = false;
                    }
                    
                    if (invoice <= 0) {
                        alert('<?php echo $lang === "ar" ? "يرجى إدخال رقم فاتورة صحيح" : "Please enter a valid invoice number"; ?>');
                        isValid = false;
                    }
                    
                    if (ttl <= 0 || ttl > 1440) {
                        alert('<?php echo $lang === "ar" ? "مدة الصلاحية يجب أن تكون بين 1 و 1440 دقيقة" : "Validity period must be between 1 and 1440 minutes"; ?>');
                        isValid = false;
                    }
                    
                } else if (action === 'payment_initiate') {
                    const phone = this.querySelector('input[name="phone_client"]').value;
                    if (!/^[0-9]{10,15}$/.test(phone)) {
                        alert('<?php echo $lang === "ar" ? "رقم الهاتف يجب أن يتكون من 10-15 رقم" : "Phone number must consist of 10-15 digits"; ?>');
                        isValid = false;
                    }
                    
                } else if (action === 'payment_confirm') {
                    const phone = this.querySelector('input[name="confirm_phone"]').value;
                    const code = this.querySelector('input[name="confirm_code"]').value;
                    
                    if (!/^[0-9]{10,15}$/.test(phone)) {
                        alert('<?php echo $lang === "ar" ? "رقم الهاتف يجب أن يتكون من 10-15 رقم" : "Phone number must consist of 10-15 digits"; ?>');
                        isValid = false;
                    }
                    
                    if (!/^[0-9]{6}$/.test(code)) {
                        alert('<?php echo $lang === "ar" ? "كود التأكيد يجب أن يتكون من 6 أرقام" : "Confirmation code must consist of 6 digits"; ?>');
                        isValid = false;
                    }
                }
                
                if (!isValid) {
                    e.preventDefault();
                }
            });
        });
        
        // وظيفة لملء بيانات الاختبار تلقائياً / Function to auto-fill test data
        function populateTestData(tabName) {
            const now = new Date();
            const timestamp = now.getTime();
            
            switch(tabName) {
                case 'create':
                    const randomInvoice = Math.floor(Math.random() * 9000) + 1000;
                    document.getElementById('create_invoice').value = randomInvoice;
                    break;
                    
                case 'payment_init':
                    document.getElementById('payment_invoice').value = Math.floor(Math.random() * 9000) + 1000;
                    document.getElementById('guid').value = 'TCS-' + now.getFullYear() + 
                        String(now.getMonth() + 1).padStart(2, '0') +
                        String(now.getDate()).padStart(2, '0') +
                        String(now.getHours()).padStart(2, '0') +
                        String(now.getMinutes()).padStart(2, '0') +
                        '-' + Math.floor(Math.random() * 10000);
                    break;
                    
                case 'payment_confirm':
                    document.getElementById('operation_number').value = '70075314' + 
                        String(Math.floor(Math.random() * 10000000)).padStart(7, '0');
                    document.getElementById('confirm_code').value = String(Math.floor(Math.random() * 900000) + 100000);
                    break;
                    
                case 'refund_confirm':
                    document.getElementById('base_invoice').value = Math.floor(Math.random() * 9000) + 1000;
                    document.getElementById('refund_invoice_confirm').value = Math.floor(Math.random() * 9000) + 1001;
                    break;
            }
        }
        
        // نسخ النص من حقول QR / Copy text from QR fields
        document.addEventListener('click', function(e) {
            if (e.target.classList.contains('qr-code')) {
                const text = e.target.textContent;
                navigator.clipboard.writeText(text).then(() => {
                    alert('<?php echo $lang === "ar" ? "تم نسخ كود QR إلى الحافظة" : "QR code copied to clipboard"; ?>');
                });
            }
        });
    </script>
</body>
</html>